/*--------------------------------------------------------------*/
/*  Written by Garry F. Fruth of G. Fruth Consulting.		*/
/*								*/
/*  GARRY@GFRUTHCONSULTING.COM					*/
/*  WWW.GFRUTHCONSULTING.COM					*/
/*--------------------------------------------------------------*/

#define MAXRSB	20000
#define MAXSUB	5000
#include <stdlib>
#include <stdio>
#include <signal>
#include <ssdef>
#include <syidef>
#include <dvidef>
#include <lib$routines>
#include <starlet>
#include <errno>
#include <string>
#include <str$routines>
#include <descrip>
#include <jpidef>
#include <rmsdef>
#include <fab>
#include <rab>
#include <nam>

/*STRUCTURE TO RECEIVE RESOURCE & LOCK INFORMATION */
#pragma nomember_alignment byte
typedef struct {
	unsigned char	resnam_len;
	unsigned char	resnam[31];
	unsigned long	csid;
	unsigned long	mode;
	unsigned long	lckcnt;
	unsigned long	first_ipid;
	unsigned long	first_epid;
	void		*first_lkb;
	void		*rsbaddr;
	} RSBENTRY ;

RSBENTRY rsbs[MAXRSB];
#pragma member_alignment
long	rsb_cnt = 0;

unsigned long	master_csid;
void		*rsb_addr;

/*Resource name */
typedef unsigned short	FID[3];
struct	{char	prefix[4];
	 FID	fid;
	} in_resnam = {"RMS$"};

/*Items to open files using RMS; this is used to get FID of file */
#pragma nomember_alignment byte
struct RAB infile_rab;
struct FAB infile_fab;
struct NAM infile_nam;
#pragma member_alignment

/*Status variables*/
enum {OK, UNK_STOP, LCK_ROOT, SUB_LOST, ROOT_LOST, TOO_MANY_RRSB, TOO_MANY_SRSB}
		why_stop=OK;
char *why_stop_desc[] = {"OK", "Unknown", "Resource not found",
	"Lost subresource chain",
	"Lost root RSB chain", "Too many RRSB", "Too many SRSB"};

/*Function prototypes*/
int  count_activity (void);
int  compare_rsbentry (const void *a, const void *b);
long exe$cvt_ipid_to_epid (long *ipid);
void get_device_name (struct dsc$descriptor_d *output,
		const unsigned char *in_devlocknam, long in_devlocknam_len);

#if !MAIN
long main (int argc, char **argx) {
	long rsb_chain (int argc, char **argx);
	return (rsb_chain (argc, argx));
}
#endif

long rsb_chain (int argc, char **argx) {
	register long sts, sts2, i;
	long continuous = 0, show_nl_locks = 0;
	static $DESCRIPTOR(ctlstr,   "!80<!6AS !4UL !8XL !8XL !15AS !2AZ !AZ!>");
	static $DESCRIPTOR(ctlstr_h,     "!6AZ !4AZ !8AZ !8AZ !15AZ !AZ");
	static struct dsc$descriptor_d
		nodename =     {0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0},
		imagname =     {0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0},
		imagname_trim ={0,DSC$K_DTYPE_T,DSC$K_CLASS_S,0},
		outbufx =      {0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0},
		tmp1_dx =      {0,DSC$K_DTYPE_T,DSC$K_CLASS_D,0};
	imagname_trim.dsc$w_length=15;
	imagname_trim.dsc$a_pointer=malloc(15);

	/*Get file id */
	if (argc > 3) {
		in_resnam.fid[0] = atol(argx[1]);
		in_resnam.fid[1] = atol(argx[2]);
		in_resnam.fid[2] = atol(argx[3]);
		}
	else	
	if (argc > 1) {
		infile_fab = cc$rms_fab;
		infile_fab.fab$b_fac = FAB$M_GET;
		infile_fab.fab$l_fna = argx[1];
		infile_fab.fab$b_fns = strlen(infile_fab.fab$l_fna);
		infile_fab.fab$b_shr = FAB$M_SHRDEL | FAB$M_SHRGET 
			| FAB$M_SHRPUT | FAB$M_SHRUPD;
		infile_fab.fab$l_nam = &infile_nam;
		infile_nam = cc$rms_nam;
		sts = sys$open(&infile_fab);
		if (!(sts&1)) {
			perror(strerror(EVMSERR, sts));
			return (sts);
			}
		memcpy(&in_resnam.fid[0], &infile_nam.nam$w_fid, 6);
		if (argc == 3 && *argx[2]=='c') continuous = 1;
		if (argc == 3 && *argx[2]=='n') show_nl_locks = 1;
		}
	else {
		printf ("filename C\n or\nfilename N\n or\nfilename\n or\nfid # # #\n");
		return (SS$_BADPARAM);
		};

	/*Connect to input file - to do rfa reads */
	infile_rab = cc$rms_rab;
	infile_rab.rab$l_fab = &infile_fab;
	sts = sys$connect(&infile_rab);

	do { /*while continuous*/
	register long sleep_time;
	/*get resource information*/
	sts = sys$cmexec (count_activity, 0);
	if (!(sts&1)) {
		perror(strerror(EVMSERR, sts));
		return (sts);
		}

	/*exit with status if we were unsuccessful*/
	/*display headers*/
	if (why_stop == OK) {
		static long hdrs_shown = 0;
		if (hdrs_shown++ == 0) {
			long tmp;
			tmp = master_csid;
			sts = lib$getsyi(&SYI$_NODENAME,0, &nodename,0, &tmp,0);
			printf("(%d,%d,%d)  rsbaddr=%x   csid=%x (%s)\n\n",
				in_resnam.fid[0],
				in_resnam.fid[1],
				in_resnam.fid[2], 
				rsb_addr, 
				master_csid, nodename.dsc$a_pointer);
			sts = lib$sys_fao(&ctlstr_h, 0, &outbufx,
				"Node", "LCnt", "RSB Addr", "pid", "image",
				"Lock description");
			if (!(sts&1)) lib$signal(sts);
			sts = lib$put_output(&outbufx);
			if (!(sts&1)) lib$signal(sts);
			}
		}
	else {
		printf("Completion status: %s\n", why_stop_desc[why_stop]);
		return 1;
		}

	/*display results*/
	sleep_time = 0;
	for (i = 0;  i < rsb_cnt; i++) if (show_nl_locks || rsbs[i].mode) {
		char *lock_modes[6] = {"NL","CR","CW","PR","PW","EX"};
		char lock_desc[80];
		long tmp, first_pid;

		/*Describe the type of rms lock*/
		if (rsbs[i].resnam_len == 4) {
			sleep_time = 0;
			sprintf(lock_desc, "Bucket lock; vbn = %d",
				*((long *)&rsbs[i].resnam[0]));
			}
		else
		if (rsbs[i].resnam_len == 8)
			sprintf(lock_desc, 
				"Record lock.  RFA=%#x%04x; VBN=%d; Rec ID=%d",
				*((long  *)&rsbs[i].resnam[0]),
				*((short *)&rsbs[i].resnam[4]),
				*((long  *)&rsbs[i].resnam[4]),
				*((long  *)&rsbs[i].resnam[0]));
		else
			sprintf(lock_desc, "Unknown lock.");

		/*display lock information*/
		tmp = rsbs[i].csid;
		sts = lib$getsyi(&SYI$_NODENAME, 0, &nodename, 0, &tmp, 0);
		if (!(sts&1)) lib$signal(sts);

		if (rsbs[i].first_ipid == 0) {
			first_pid = rsbs[i].first_epid;
			}
		else {
			tmp = rsbs[i].first_ipid;
			first_pid = exe$cvt_ipid_to_epid(&tmp);
			}

		sts = lib$getjpi(&JPI$_IMAGNAME, &first_pid, 0, 0, &imagname);
		if (sts==SS$_NOPRIV) {
			sts2 = lib$sfree1_dd (&imagname);
			memcpy(imagname_trim.dsc$a_pointer,"NO WORLD PRIV  ",15);
			}
		else if (sts==SS$_NONEXPR) {
			sts2 = lib$sfree1_dd (&imagname);
			memcpy(imagname_trim.dsc$a_pointer,"IMAGE UNKNOWN  ",15);
			}
		else if (sts&1) {
			sts = lib$trim_filespec (&imagname, &imagname_trim);
			sts2 = lib$sfree1_dd (&imagname);
			}
		else	lib$signal(sts);

		sts = lib$sys_fao(&ctlstr, 0, &outbufx,
			&nodename,
			rsbs[i].lckcnt,
			rsbs[i].rsbaddr,
			first_pid,
			&imagname_trim,
			lock_modes[rsbs[i].mode],
			lock_desc);
		if (!(sts&1)) lib$signal(sts);
		sts = lib$put_output(&outbufx);
		if (!(sts&1)) lib$signal(sts);

		/*display record if this is a record lock*/
		if (rsbs[i].resnam_len == 8) {
			infile_rab.rab$b_rac = RAB$C_RFA;
			infile_rab.rab$l_rop = RAB$M_LOC | RAB$M_RRL;
			infile_rab.rab$l_ubf = malloc(64);
			infile_rab.rab$w_usz = 64;
			infile_rab.rab$l_rfa0 = *(long  *)(&rsbs[i].resnam[4]);
			infile_rab.rab$w_rfa4 = *(short *)(&rsbs[i].resnam[0]);
			sts = sys$get(&infile_rab);
			if (sts&1) {
				$DESCRIPTOR(ctlstr,"    !75AF");
				sts = lib$sys_fao(&ctlstr, 0, &outbufx,
					infile_rab.rab$w_rsz,
					infile_rab.rab$l_rbf);
				if (sts&1)
					sts = lib$put_output (&outbufx);
				}
			}
		} /*for*/
	sleep (sleep_time);
	} while (continuous); /*do*/
	return 1;
}

#if defined(__DECC) || defined(__DECCXX)
# pragma extern_model __save
# pragma extern_model globalvalue
	extern void *LCK$GL_RRSFL;
	extern long RSB$L_RRSFL, RSB$L_SRSFL;
	extern long RSB$W_ACTIVITY, RSB$W_NACT, RSB$W_OACT, RSB$L_CSID;
	extern long RSB$W_LCKCNT;
	extern long RSB$B_GGMODE, RSB$B_RSNLEN, RSB$T_RESNAM;
	extern long RSB$L_GRQFL;
	extern long LKB$L_CSID, LKB$L_SQFL, LKB$L_PID, LKB$L_EPID;
# pragma extern_model __restore
#else
	globalvalue void (*LCK$GL_RRSFL);
	globalvalue long RSB$L_RRSFL, RSB$L_SRSFL;
	globalvalue long RSB$W_ACTIVITY, RSB$W_NACT, RSB$W_OACT, RSB$L_CSID;
	globalvalue long RSB$B_GGMODE, RSB$B_RSNLEN, RSB$T_RESNAM;
	globalvalue long RSB$L_GRQFL;
	globalvalue long LKB$L_CSID, LKB$L_SQFL, LKB$L_PID, LKB$L_EPID;
#endif

int count_activity (void) {
	void **current_rrsb, **parent_srsb, **current_srsb;
	register char *rsb, *p, *lkb;

/*Locate RSB for file*/
	current_rrsb= *(void **)LCK$GL_RRSFL;
	for (; 1; current_rrsb = *current_rrsb) {
		if (current_rrsb==0) {
			why_stop = ROOT_LOST;
			return 1;};
		if (current_rrsb==(void **)LCK$GL_RRSFL) {
			why_stop = LCK_ROOT;
			return 1;};

		rsb = (char *)current_rrsb - RSB$L_RRSFL;
		p = rsb + RSB$B_RSNLEN;
		p = rsb + RSB$T_RESNAM;
		if (memcmp(p, &in_resnam, sizeof in_resnam) == 0) {
			why_stop = OK;
			rsb_addr = rsb;
			master_csid = *(unsigned long *)(rsb + RSB$L_CSID);
			break;}
		}

/*get all sub-locks for current resource*/
	parent_srsb = (void *)(rsb + RSB$L_SRSFL);
	rsb_cnt = 0;
	for (current_srsb = *parent_srsb; current_srsb != parent_srsb; 
		current_srsb = *current_srsb) {
		if (current_srsb==0) {
			why_stop = SUB_LOST;
			return 1;};

		if (rsb_cnt > MAXRSB) {
			why_stop = TOO_MANY_SRSB;
			return 1;};

		rsb = (char *)current_srsb - RSB$L_SRSFL;
		rsbs[rsb_cnt].rsbaddr	= rsb;

		/*resource name*/
		p = rsb + RSB$B_RSNLEN;
		memcpy(&rsbs[rsb_cnt].resnam_len, p, 32);

		/*lock count of resource; not necessarily granted*/
		p = rsb + RSB$W_LCKCNT;
		rsbs[rsb_cnt].lckcnt	= *(unsigned short *)p;

		/*resource grant queue mode (Group Grant MODE)*/
		p = rsb + RSB$B_GGMODE;
		rsbs[rsb_cnt].mode	= *(unsigned char *)p;

		/*pid of first granted lock*/
		lkb = *(char **)(rsb + RSB$L_GRQFL) - LKB$L_SQFL ;
		rsbs[rsb_cnt].first_lkb = lkb;
		p = lkb + LKB$L_PID;
		rsbs[rsb_cnt].first_ipid	= *(unsigned long *)p;
		p = lkb + LKB$L_EPID;
		rsbs[rsb_cnt].first_epid	= *(unsigned long *)p;
		if (rsbs[rsb_cnt].first_ipid == 0) {
			p = lkb + LKB$L_CSID;
			rsbs[rsb_cnt].csid	= *(unsigned long *)p;
			}
		else {
			rsbs[rsb_cnt].csid	= 0;
			}

		rsb_cnt += 1;
	}
	
	return 1;
}
