$!DEL HOT_LOCKS.RDB;*
$!DEL HOT_LOCKS.SNP;*
$DEFINE SQL$DATABASE HOT_LOCKS
$MC SQL$

CREATE DATABASE FILENAME 'HOT_LOCKS'
	NUMBER OF BUFFERS 2000
	BUFFER SIZE IS 24
	NUMBER OF CLUSTER NODES 3
	NUMBER OF USERS 20
	SNAPSHOT DISABLED
	ADJUSTABLE LOCK GRANULARITY ENABLED

CREATE STORAGE AREA RDB$SYSTEM FILENAME HOT_LOCKS
	ALLOCATION IS 2000
	EXTENT IS 1000 PAGE SIZE IS 8 BLOCKS

CREATE TABLE NODES (	TMSTMP		DATE VMS,
			NODE		CHAR(8),
			PRIMARY KEY (TMSTMP, NODE) NOT DEFERRABLE,
			LOCAL_LOCKING	INTEGER, 
			DIST_LOCKING	INTEGER)

CREATE TABLE FILE_NODE_LOCKS (
			TMSTMP		DATE VMS,
			NODE		CHAR(8),
			FOREIGN KEY (TMSTMP, NODE) REFERENCES NODES DEFERRABLE,
			LOCAL_LOCKING	INTEGER,
			DIST_LOCKING	INTEGER,
			CHECK ( (LOCAL_LOCKING IS NULL
					AND DIST_LOCKING IS NOT NULL)
			   OR   (LOCAL_LOCKING IS NOT NULL 
					AND DIST_LOCKING IS NULL)
			      ) NOT DEFERRABLE,
			FILENAME	VARCHAR(128),
			PRIMARY KEY (TMSTMP, NODE, FILENAME) NOT DEFERRABLE)

CREATE INDEX NODES_PKEY ON NODES (TMSTMP, NODE)
	TYPE IS SORTED DISABLE COMPRESSION

CREATE INDEX FILE_NODE_LOCKS_PKEY
	ON FILE_NODE_LOCKS (TMSTMP, NODE, FILENAME)
	TYPE IS SORTED ENABLE COMPRESSION

CREATE INDEX TMSTMP_FILENAME_INDEX
	ON FILE_NODE_LOCKS (TMSTMP, FILENAME)
	TYPE IS SORTED ENABLE COMPRESSION

;

CREATE VIEW LOCKING_OVER_TIME (TMSTMP, LOCAL_LOCKING, DIST_LOCKING, NODE_CNT) AS
	SELECT TMSTMP, SUM(LOCAL_LOCKING), SUM(DIST_LOCKING), COUNT(*)
		FROM NODES GROUP BY TMSTMP;

CREATE VIEW FILE_LOCKING_OVER_TIME
	(TMSTMP, FILENAME, LOCAL_LOCKING, DIST_LOCKING, NODE_CNT) AS
	SELECT TMSTMP, FILENAME, SUM(LOCAL_LOCKING), SUM(DIST_LOCKING), COUNT(*)
		FROM FILE_NODE_LOCKS GROUP BY TMSTMP, FILENAME;

CREATE VIEW FILE_MASTER_NODE (TMSTMP, FILENAME, MASTER_NODE) AS
	SELECT TMSTMP, FILENAME, NODE FROM FILE_NODE_LOCKS 
	WHERE LOCAL_LOCKING IS NOT NULL;

COMMIT;
$EXIT
