#include <stdio>
#include <stdlib>
#include <ssdef>
#include <starlet>
#include <errno>
#include <string>
#include <descrip>
#include <lckdef>
#include <time>

typedef struct {
	unsigned short	sts, unk;
	unsigned long	lock_id;
	} LKSB ;

LKSB lock_1_lksb, lock_1a_lksb, lock_2_lksb;

int main (int argc, char **argx) {
	register int top = 5000;
	long sts;

	if (argc > 1) top = atol(argx[1]);

	{/*wake up 10 times a second*/
		long reptim[2], today[2];
		$DESCRIPTOR (reptim_desc,"0 0:0:0.01");
		sts = sys$bintim(&reptim_desc, &reptim);
		if (!(sts&1)) perror(strerror(EVMSERR, sts));
		sts = sys$schdwk(0, 0, &reptim, &reptim);
		if (!(sts&1)) perror(strerror(EVMSERR, sts));
	}

	{/*enque parent lock_1 (nl)*/
		$DESCRIPTOR(lock_1_name, "lock_1");
		sts = sys$enqw(0, LCK$K_NLMODE, &lock_1_lksb, 0, &lock_1_name,
			0, 0, 0, 0, 0, 0);
		if (!(sts&1)) perror(strerror(EVMSERR, sts));
	}

	{/*enque sub-lock lock_1a (nl)*/
		$DESCRIPTOR(lock_1a_name, "lock_1a");
		sts = sys$enqw(0, LCK$K_NLMODE, &lock_1a_lksb, 0, &lock_1a_name,
			lock_1_lksb.lock_id, 0, 0, 0, 0, 0);
		if (!(sts&1)) perror(strerror(EVMSERR, sts));
	}

	{/*enque parent lock_2 (nl)*/
		$DESCRIPTOR(lock_2_name, "lock_2");
		sts = sys$enqw(0, LCK$K_NLMODE, &lock_2_lksb, 0, &lock_2_name,
			0, 0, 0, 0, 0, 0);
		if (!(sts&1)) perror(strerror(EVMSERR, sts));
	}

	{/*enque/deque lock_1a (nl) 100000 times*/
		$DESCRIPTOR(lock_1a_name, "lock_1");
		clock_t last_t = clock(), total_cpu = 0;
		LKSB lock_1a_lksb;
		int count = 0, mode_sw_2=0;
		while (count < top*10) {

		sts = sys$enqw(0, LCK$K_NLMODE, &lock_1a_lksb, 0, &lock_1a_name,
			lock_1_lksb.lock_id, 0, 0, 0, 0, 0);
/*			0, 0, 0, 0, 0, 0);*/
		if (!(sts&1)) perror(strerror(EVMSERR, sts));
		sts = sys$deq(lock_1a_lksb.lock_id,0,0,0);
		if (!(sts&1)) perror(strerror(EVMSERR, sts));

		if (!(++count % top)) { 
			total_cpu = total_cpu + clock() - last_t;
			printf ("%d enq/deq's cpu time = %d, avg=%d\n", top,
				clock() - last_t, total_cpu/(count/top));
			last_t = clock();
			}}
	}

	{/*convert all locks, 10 times a second*/
	int mode_sw = 0, mode_sw_1a = 0, mode_sw_2 = 0;
	int count = 0;
	clock_t last_t = clock(), total_cpu = 0;
	while (count < top*20) {

/*		sts = sys$hiber();*/
		if (!(sts&1)) perror(strerror(EVMSERR, sts));

		sts = sys$enqw(0, mode_sw = 5 - mode_sw,
			&lock_1_lksb, LCK$M_CONVERT, 0,
			0, 0, 0, 0, 0, 0);
		if (!(sts&1)) perror(strerror(EVMSERR, sts));

/*		if (!(count%10)) {
/*			sts = sys$enqw(0, mode_sw_1a = 1 - mode_sw_1a,
/*				&lock_1a_lksb, LCK$M_CONVERT, 0,
/*				0, 0, 0, 0, 0, 0);
/*			if (!(sts&1)) perror(strerror(EVMSERR, sts));
/*
/*			sts = sys$enqw(0, mode_sw_2 = 1 - mode_sw_2,
/*				&lock_2_lksb, LCK$M_CONVERT, 0,
/*				0, 0, 0, 0, 0, 0);
/*			if (!(sts&1)) perror(strerror(EVMSERR, sts));
/*
/*			}
/*
/*		if (!(++count % 80)) { */
		if (!(++count % (top *2))) { 
			total_cpu = total_cpu + clock() - last_t;
			printf("%d lock converts cpu time = %d, avg=%d\n",top*2,
				clock() - last_t, total_cpu/(count/(top*2)));
			last_t = clock();
			}
		}
	}

	return 1;
}
